/*
  INCLUDE-Datei fr Microsoft "QuickC 1.01"
  Bezeichnerliste fr Assembler-Funktionen
  zur Untersttzung der HAMEG Interface-Karte HO80-IEEE488
*/

#define ieee_se(a)      IEEE_SE(a)
#define init(a,b)       INIT ((int far *) a,(int far *) b)
#define iwsd(a,b)       IWSD((int far *) a,(char far *) b)
#define irsd(a,b,c)     IRSD((int far *) a,(int far *) b,\
                             (char far *) c)
#define iwd(a,b,c)      IWD((int far *) a,(char far *) b,\
                            (int far *) c)
#define ispl(a,b,c)     ISPL((int far *) a,(int far *) b,\
                             (int far *) c)
#define ippl(a)         IPPL((int far *) a)
#define ird(a,b,c,d)    IRD((int far *) a,(int far *) b,\
                            (int far *) c,(char far *) d)
#define iwda(a,b,c,d,e) IWDA((int far *) a,(int far *) b,\
                             (int far *) c,(int far *) d,\
                             (int far *) e)
#define irda(a,b,c,d,e) IRDA((int far *) a,(int far *) b,\
                             (int far *) c,(int far *) d,\
                             (int far *) e)
extern int HO80_SEG;


/*

Die Funktionensbeschreibung ist dem Handbuch aus der Befehlsliste
zu entnehmen.
Hier werden nur Abweichungen zu diesen Erklrungen aufgefhrt.

HO80_SEG
  Speicheradresse der HO80 Interfacekarte
  Die Adresse ist auf C400H vordefiniert.
  Wird eine andere Adresse verwendet, so ist diese
  HO80_Seg zuzuweisen.  (z.B.:  HO80_SEG = 0xC000 )


ieee_se
  Die Funktion testet ob an der bergebenen Segmentadresse
  eine HO80 Interfacekarte installiert ist, und bergibt
  die Segmentadresse HO80_SEG.
  Diese Funktion sollte vor IEEE-Routinen aufgerufen werden.
  (Siehe Programm DEMO208.C )
  Ist die Segmentadresse unbekannt, kann sie folgendermaen
  ermittelt werden:
    HO80_SEG = 0x0000;
    while ((ieee_se (HO80_SEG)) && (HO80_SEG < 0xFE00))
    { HO80_SEG += 0x0200; }


iwda, irda
  Die Funktion entspricht der Beschreibung im Handbuch; die
  Segmentbergabe ist jedoch nur aus Kompatibilittsgrnden
  aufgefhrt und kann ein beliebiger Zeiger sein.

*/